import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/data/services/api_service.dart';

import '../../../../../core/helper/date_converter.dart';
import '../../../../../core/helper/string_format_helper.dart';
import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';
import '../../../../../core/utils/util.dart';
import '../../../../../data/controller/invoice/invoice_history_controller.dart';
import '../../../../components/divider/custom_divider.dart';
import '../../../add-money/add_money_history/widget/status_widget.dart';

class InvoiceCard extends StatelessWidget {
  final int index;
  const InvoiceCard({super.key, required this.index});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<InvoiceHistoryController>(
      builder: (controller) => Container(
        width: MediaQuery.of(context).size.width,
        padding: const EdgeInsets.all(Dimensions.space10),
        decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: BorderRadius.circular(Dimensions.defaultRadius), boxShadow: MyUtils.getCardShadow()),
        child: Column(
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(MyStrings.invoicesNO.tr, style: regularSmall.copyWith(color: MyColor.colorBlack.withValues(alpha: 0.6))),
                    const SizedBox(height: Dimensions.space5),
                    Text(
                      controller.invoiceList[index].invoiceUid ?? "",
                      style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                    )
                  ],
                ),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  children: [
                    Text(MyStrings.date.tr, style: regularSmall.copyWith(color: MyColor.colorBlack.withValues(alpha: 0.6))),
                    const SizedBox(height: Dimensions.space5),
                    Text(
                      DateConverter.isoStringToLocalDateOnly(controller.invoiceList[index].createdAt ?? ""),
                      style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                    )
                  ],
                ),
              ],
            ),
            const CustomDivider(space: Dimensions.space10),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(MyStrings.amount.tr, style: regularSmall.copyWith(color: MyColor.colorBlack.withValues(alpha: 0.6))),
                    const SizedBox(height: Dimensions.space5),
                    Text(
                      "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${StringConverter.formatNumber(controller.invoiceList[index].totalAmount ?? "")}",
                      style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                    )
                  ],
                ),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  children: [
                    Text(MyStrings.status.tr, style: regularSmall.copyWith(color: MyColor.colorBlack.withValues(alpha: 0.6))),
                    const SizedBox(height: Dimensions.space5),
                    StatusWidget(
                      status: controller.getStatusOrColor(index),
                      color: controller.getStatusOrColor(index, isStatus: false),
                    )
                  ],
                )
              ],
            )
          ],
        ),
      ),
    );
  }
}
